set more off
#delim cr
version 8
pause on

capture log close

clear

foreach m in 01 02 03 04 05 06 07 08 09 10 11 12 {

gzuse /mcr/data_labor/cps/basic/stata/cpsb`1'`m'.dta.gz, clear

rename pesex sex
rename peage age
rename gestcen state
keep if age>=16 

rename pwsswgt finwgt

gen empstat=1 if pemlr==1 | pemlr==2
replace empstat=2 if pemlr==3 
replace empstat=0 if empstat==.

gen ed=1 if peeduca<=12 | peeduca==.
replace ed=2 if peeduca==13
replace ed=3 if peeduca>=14 & peeduca<=16
replace ed=4 if peeduca>=17 & peeduca!=.

replace finwgt=finwgt/12

gen ageg=1 if age>=16 & age<=18
replace ageg=2 if age>=19 & age<=24
replace ageg=3 if age>=25 & age<=54
replace ageg=4 if age>=55

sort state sex ageg ed empstat 

keep state sex ageg ed empstat finwgt

collapse (sum) finwgt, by(state sex ageg ed empstat)
gen year=`1'
gen month=`m'
compress

tempfile temp`m'
save `temp`m'', replace
}

use `temp01', clear
foreach m in 02 03 04 05 06 07 08 09 10 11 12 {
append using `temp`m''
}

save research/brookings/polar/dta/morg_cleaned_`1'_emp, replace

 

